* Program to correct address via the ZipCodeData interface
* of the AddressObject component 
*********************************************************************************
*If you should have any comments, suggestions or improvements to these samples, 
*we welcome you to contact us at SampleCode@melissadata.com also please visit our 
*developers bulletin board at forum.melissadata.com.
*********************************************************************************

close all
clear

* Use and remove any previous records 
use "C:\Program Files\Melissa DATA\DQT\AddrObj\Samples\VFP60\Addr\correct.dbf" alias correct shared

* Use the ZipCodeData interface of the AddressObject component
AdrObject = CreateObject('AddressObject.AddressCheck')

********************** LICENSE STRINGS *************************
*      To unlock the full functionality of Address Object,     *
*  please call a sales representative at 1-800-MELISSA ext. 3  *
*          (1-800-635-4772 x3) for a license string.           *
*       Without a valid license string, AddressCheck will      *
*                 only verify Nevada addresses.                *
*                                                              *
* NOTE: Replace DEMO in the parameter with your license string *
****************************************************************
if (AdrObject.SetLicenseString("DEMO") = 0)
	@1,1 say "Component is in DEMO Mode"
endif

************************* DATA FILE PATH  ***********************
*  File location path is set to the default Data File location. *
*  Change this value if you installed the data files to a       *
*  different folder.                                            *
*  The Data Files Directory must contain the following files:   *
*  mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str           *
*****************************************************************
AdrObject.PathToUSFiles = "C:\Program Files\Melissa DATA\DQT\Data"

* CASS required add-ons for highest level of validation. Should be used by non-demo users.
*AdrObject.PathToDPVDataFiles = "C:\Program Files\Melissa DATA\DQT\Data"
*AdrObject.PathToLACSLinkDataFiles = "Path to Data Files"
*AdrObject.PathToSuiteLinkDataFiles = "Path to Data Files"

*AdrObject.PathToCanadaFiles = "Path to Data Files"           *Canadian Address Validation Add-on
*AdrObject.PathToRBDIFiles = "Path to Data Files"             *Delivery Indicator Add-on (Residence or Business)
*AdrObject.PathToSuiteFinderDataFiles = "Path to Data Files"  *AddressPlus Add-on (appends residential suites)

* Initialize the data files. 
if (AdrObject.InitializeDataFiles()!=0)
	wait AdrObject.GetInitializeErrorString
	return
endif

@2,1 say "Initialized"

do while !EOF()

	* Set up properties for this record
	AdrObject.ClearProperties
	AdrObject.Address = address
	AdrObject.City = city
	AdrObject.State = state
	AdrObject.Zip = zip
	
	*Last Name Input for Suite Finder
	*AdrObject.LastName = "Enter Last Name Here"

	* Check the Address
	result = AdrObject.VerifyAddress

	* On a good return, write these fields
	if (result <> 0)
		* We need to append the suite to the address
		newadd = AdrObject.Address + " " + AdrObject.Suite
		replace caddress with newadd
		replace city with AdrObject.City
		replace state with AdrObject.State
		replace zip with AdrObject.Zip
		replace plus4 with AdrObject.Plus4
		replace dpb with AdrObject.DeliveryPointCode
		replace cntyfips with AdrObject.CountyFips
		replace cntyname with AdrObject.CountyName
		replace elotorder with AdrObject.ELotOrder
		replace elotnumber with AdrObject.ELotNumber
		replace timezone with AdrObject.TimeZone
		replace timecode with AdrObject.TimeZoneCode
		replace msa with AdrObject.Msa
		replace pmsa with AdrObject.Pmsa
		replace addrtyp with AdrObject.AddressTypeCode
		replace addrtypstr with AdrObject.AddressTypeString
		replace urban with AdrObject.Urbanization
		replace cd with AdrObject.CongressionalDistrict
		replace lacs with AdrObject.Lacs
		replace stelnkcde with AdrObject.SuiteLinkReturnCode
		replace results with AdrObject.Results
	endif

	* On a bad return, write these fields
	if (result = 0)
		replace results with AdrObject.Results
	endif

	* Check next record
	skip

enddo
IF FILE("C:\CassForm.html") 
   FileHandle = FOPEN("C:\CassForm.html",12)
ELSE
   FileHandle = FCREATE("C:\CassForm.html")
ENDIF


if(FileHandle <> -1)
	FWRITE(FileHandle,AdrObject.GetCASSForm())
	FCLOSE(FileHandle)
else
	wait "ERROR: Can't open CassForm.html"
endif
release AdrObject